#!/usr/bin/perl
# Xiaobin Li on Mar-19-2019
# School of Life Sciences & Biotechnology, Shanghai Jiao Tong University
use strict;
use Bio::SearchIO;

die "usage: $0 <job_id >" if @ARGV != 1;

my $job_id = shift;
my $tmp_path = "./tmp/$job_id";

#gapA
my $seqfile_result_gapA = "$tmp_path/gapA.out";
my $gapA = "$tmp_path/gapA.txt";
if(-e $seqfile_result_gapA){
	open FILE1, "> $gapA";
	print FILE1 "query_name\tevalue\thit_name\thvalue\n";
	my $in = new Bio::SearchIO(-format => 'blast', 
							   -file   => $seqfile_result_gapA);
	while( my $result = $in->next_result ){
	## $result is a Bio::Search::Result::ResultI compliant object
		my $n=0;
		while( my $hit = $result->next_hit ){
		## $hit is a Bio::Search::Hit::HitI compliant object
			$n++;
			while( my $hsp = $hit->next_hsp ){			   
				my $identities= sprintf("%.2f",$hsp->percent_identity);  					
				my $hvalue= sprintf("%.2f",$identities *($hsp->length('total')/$hit->length)/100);
				if($hvalue == 1.00){
					my $myquery_name = $result->query_name;
					my $myhit_name = $hit->name;
					print FILE1 $myquery_name,"\t",$hsp->evalue,"\t",$myhit_name,"\t",$hvalue,"\n";
				}
				last;
			}
			last;
	   }
	}
	close FILE1;
}


#infB
my $seqfile_result_infB = "$tmp_path/infB.out";
my $infB = "$tmp_path/infB.txt";
if(-e $seqfile_result_infB){
	open FILE2, "> $infB";
	print FILE2 "query_name\tevalue\thit_name\thvalue\n";
	my $in = new Bio::SearchIO(-format => 'blast', 
							   -file   => $seqfile_result_infB);
	while( my $result = $in->next_result ){
	## $result is a Bio::Search::Result::ResultI compliant object
		my $n=0;
		while( my $hit = $result->next_hit ){
		## $hit is a Bio::Search::Hit::HitI compliant object
			$n++;
			while( my $hsp = $hit->next_hsp ){			   
				my $identities= sprintf("%.2f",$hsp->percent_identity);  					
				my $hvalue= sprintf("%.2f",$identities *($hsp->length('total')/$hit->length)/100);
				if($hvalue == 1.00){
					my $myquery_name = $result->query_name;
					my $myhit_name = $hit->name;
					print FILE2 $myquery_name,"\t",$hsp->evalue,"\t",$myhit_name,"\t",$hvalue,"\n";
				}
				last;
			}
			last;
	   }
	}
	close FILE2;
}

#mdh
my $seqfile_result_mdh = "$tmp_path/mdh.out";
my $mdh = "$tmp_path/mdh.txt";
if(-e $seqfile_result_mdh){
	open FILE3, "> $mdh";
	print FILE3 "query_name\tevalue\thit_name\thvalue\n";
	my $in = new Bio::SearchIO(-format => 'blast', 
							   -file   => $seqfile_result_mdh);
	while( my $result = $in->next_result ){
	## $result is a Bio::Search::Result::ResultI compliant object
		my $n=0;
		while( my $hit = $result->next_hit ){
		## $hit is a Bio::Search::Hit::HitI compliant object
			$n++;
			while( my $hsp = $hit->next_hsp ){			   
				my $identities= sprintf("%.2f",$hsp->percent_identity);  					
				my $hvalue= sprintf("%.2f",$identities *($hsp->length('total')/$hit->length)/100);
				if($hvalue == 1.00){
					my $myquery_name = $result->query_name;
					my $myhit_name = $hit->name;
					print FILE3 $myquery_name,"\t",$hsp->evalue,"\t",$myhit_name,"\t",$hvalue,"\n";
				}
				last;
			}
			last;
	   }
	}
	close FILE3;
}

#pgi
my $seqfile_result_pgi = "$tmp_path/pgi.out";
my $pgi = "$tmp_path/pgi.txt";
if(-e $seqfile_result_pgi){
	open FILE4, "> $pgi";
	print FILE4 "query_name\tevalue\thit_name\thvalue\n";
	my $in = new Bio::SearchIO(-format => 'blast', 
							   -file   => $seqfile_result_pgi);
	while( my $result = $in->next_result ){
	## $result is a Bio::Search::Result::ResultI compliant object
		my $n=0;
		while( my $hit = $result->next_hit ){
		## $hit is a Bio::Search::Hit::HitI compliant object
			$n++;
			while( my $hsp = $hit->next_hsp ){			   
				my $identities= sprintf("%.2f",$hsp->percent_identity);  					
				my $hvalue= sprintf("%.2f",$identities *($hsp->length('total')/$hit->length)/100);
				if($hvalue == 1.00){
					my $myquery_name = $result->query_name;
					my $myhit_name = $hit->name;
					print FILE4 $myquery_name,"\t",$hsp->evalue,"\t",$myhit_name,"\t",$hvalue,"\n";
				}
				last;
			}
			last;
	   }
	}
	close FILE4;
}

#phoE
my $seqfile_result_phoE = "$tmp_path/phoE.out";
my $phoE = "$tmp_path/phoE.txt";
if(-e $seqfile_result_phoE){
	open FILE5, "> $phoE";
	print FILE5 "query_name\tevalue\thit_name\thvalue\n";
	my $in = new Bio::SearchIO(-format => 'blast', 
							   -file   => $seqfile_result_phoE);
	while( my $result = $in->next_result ){
	## $result is a Bio::Search::Result::ResultI compliant object
		my $n=0;
		while( my $hit = $result->next_hit ){
		## $hit is a Bio::Search::Hit::HitI compliant object
			$n++;
			while( my $hsp = $hit->next_hsp ){			   
				my $identities= sprintf("%.2f",$hsp->percent_identity);  					
				my $hvalue= sprintf("%.2f",$identities *($hsp->length('total')/$hit->length)/100);
				if($hvalue == 1.00){
					my $myquery_name = $result->query_name;
					my $myhit_name = $hit->name;
					print FILE5 $myquery_name,"\t",$hsp->evalue,"\t",$myhit_name,"\t",$hvalue,"\n";
				}
				last;
			}
			last;
	   }
	}
	close FILE5;
}

#rpoB
my $seqfile_result_rpoB= "$tmp_path/rpoB.out";
my $rpoB= "$tmp_path/rpoB.txt";
if(-e $seqfile_result_rpoB){
	open FILE6, "> $rpoB";
	print FILE6 "query_name\tevalue\thit_name\thvalue\n";
	my $in = new Bio::SearchIO(-format => 'blast', 
							   -file   => $seqfile_result_rpoB);
	while( my $result = $in->next_result ){
	## $result is a Bio::Search::Result::ResultI compliant object
		my $n=0;
		while( my $hit = $result->next_hit ){
		## $hit is a Bio::Search::Hit::HitI compliant object
			$n++;
			while( my $hsp = $hit->next_hsp ){			   
				my $identities= sprintf("%.2f",$hsp->percent_identity);  					
				my $hvalue= sprintf("%.2f",$identities *($hsp->length('total')/$hit->length)/100);
				if($hvalue == 1.00){
					my $myquery_name = $result->query_name;
					my $myhit_name = $hit->name;
					print FILE6 $myquery_name,"\t",$hsp->evalue,"\t",$myhit_name,"\t",$hvalue,"\n";
				}
				last;
			}
			last;
	   }
	}
	close FILE6;
}

#tonB
my $seqfile_result_tonB = "$tmp_path/tonB.out";
my $tonB = "$tmp_path/tonB.txt";
if(-e $seqfile_result_tonB){
	open FILE7, "> $tonB";
	print FILE7 "query_name\tevalue\thit_name\thvalue\n";
	my $in = new Bio::SearchIO(-format => 'blast', 
							   -file   => $seqfile_result_tonB);
	while( my $result = $in->next_result ){
	## $result is a Bio::Search::Result::ResultI compliant object
		my $n=0;
		while( my $hit = $result->next_hit ){
		## $hit is a Bio::Search::Hit::HitI compliant object
			$n++;
			while( my $hsp = $hit->next_hsp ){			   
				my $identities= sprintf("%.2f",$hsp->percent_identity);  					
				my $hvalue= sprintf("%.2f",$identities *($hsp->length('total')/$hit->length)/100);
				if($hvalue == 1.00){
					my $myquery_name = $result->query_name;
					my $myhit_name = $hit->name;
					print FILE7 $myquery_name,"\t",$hsp->evalue,"\t",$myhit_name,"\t",$hvalue,"\n";
				}
				last;
			}
			last;
	   }
	}
	close FILE7;
}
exit;

