#!/usr/bin/perl
# Xiaobin Li on Mar-19-2019
# School of Life Sciences & Biotechnology, Shanghai Jiao Tong University
use strict;

die "usage: $0 <job_id >" if @ARGV != 1;

my $job_id = shift;
my $tmp_path = "./tmp/$job_id";
my $gapA = "$tmp_path/gapA.txt";
my $infB = "$tmp_path/infB.txt";
my $mdh = "$tmp_path/mdh.txt";
my $pgi = "$tmp_path/pgi.txt";
my $phoE = "$tmp_path/phoE.txt";
my $rpoB= "$tmp_path/rpoB.txt";
my $tonB = "$tmp_path/tonB.txt";
my $kpneumoniae = "./data/kpneumoniae.tsv";
my $summary = "./result/$job_id\_MLST.txt";
my $content = "Strain\tST\tgapA\tinfB\tmdh\tpgi\tphoE\trpoB\ttonB\n";

#gapA
my $hit_gapA = 0;
if (-e $gapA){		
	open (RESULT1, $gapA);
	while(<RESULT1>){
		#query_name\tevalue\thit_name\thvalue
		next if /^query\_name/;
		chomp;
		my @array = split(/\t/, $_);
		if ($array[2] =~ /gapA\_(\d+)/){
			$hit_gapA = $1;
		}
	}
	close RESULT1;
}

#infB
my $hit_infB = 0;
if (-e $infB){	
	open (RESULT2, $infB);
	while(<RESULT2>){
		next if /^query\_name/;
		chomp;
		my @array = split(/\t/, $_);
		if ($array[2] =~ /infB_(\d+)/){
			$hit_infB = $1;
		}
	}
	close RESULT2;
}

#mdh
my $hit_mdh = 0;
if (-e $mdh){		
	open (RESULT3, $mdh);
	while(<RESULT3>){
		next if /^query\_name/;
		chomp;
		my @array = split(/\t/, $_);
		if ($array[2] =~ /mdh_(\d+)/){
			$hit_mdh = $1;
		}
	}
	close RESULT3;
}

#pgi
my $hit_pgi = 0;
if (-e $pgi){		
	open (RESULT4, $pgi);
	while(<RESULT4>){
		next if /^query\_name/;
		chomp;
		my @array = split(/\t/, $_);
		if ($array[2] =~ /pgi_(\d+)/){
			$hit_pgi = $1;
		}
	}
	close RESULT4;
}

#phoE
my $hit_phoE = 0;
if (-e $phoE){		
	open (RESULT5, $phoE);
	while(<RESULT5>){
		next if /^query\_name/;
		chomp;
		my @array = split(/\t/, $_);
		if ($array[2] =~ /phoE_(\d+)/){
			$hit_phoE = $1;
		}
	}
	close RESULT5;
}

#rpoB
my $hit_rpoB = 0;
if (-e $rpoB){		
	open (RESULT6, $rpoB) ;
	while(<RESULT6>){
		next if /^query\_name/;
		chomp;
		my @array = split(/\t/, $_);
		if ($array[2] =~ /rpoB_(\d+)/){
			$hit_rpoB = $1;
		}
	}
	close RESULT6;
}

#tonB
my $hit_tonB = 0;
if (-e $tonB){		
	open (RESULT7, $tonB) ;
	while(<RESULT7>){
		next if /^query\_name/;
		chomp;
		my @array = split(/\t/, $_);
		if ($array[2] =~ /tonB_(\d+)/){
				$hit_tonB = $1;
		}
	}
	close RESULT7;
}

#kpneumoniae.tsv
my $ST_num = 0;
if (-e $kpneumoniae){
	if(-s $kpneumoniae){	
			open (RESULT8, $kpneumoniae) ;
			while(<RESULT8>){
				#ST	gapA	infB	mdh	pgi	phoE	rpoB	tonB
				#1	4	4	1	1	7	4	10
				next unless /^\d+/;
				chomp;
				my @array = split(/\t/, $_);
				next unless ($array[1]==$hit_gapA)&&($array[2]==$hit_infB)&&($array[3]==$hit_mdh)&&($array[4]==$hit_pgi)&&($array[5]==$hit_phoE)&&($array[6]==$hit_rpoB)&&($array[7]==$hit_tonB);
				$ST_num = $array[0];				
			}
			close RESULT8;
	}
}
if($ST_num == 0){
	$content .= "$job_id\t-\t$hit_gapA\t$hit_infB\t$hit_mdh\t$hit_pgi\t$hit_phoE\t$hit_rpoB\t$hit_tonB\n";			
}else{
	$content .= "$job_id\tST$ST_num\t$hit_gapA\t$hit_infB\t$hit_mdh\t$hit_pgi\t$hit_phoE\t$hit_rpoB\t$hit_tonB\n";
}
print $content;	
open OUT, ">$summary";
print OUT $content;
close OUT;
exit;

